//=============================================================================
// Block, Deployed.
//=============================================================================
class BlockFace extends Actor;

var BlockDeployed Parent;
var int CurSide;
var float ScaleMult;

function Vector GetNormal(int Side)
{
 if (Side == 0) return vect(0,0,1) * Parent.CollisionRadius * Parent.DrawScale;
 if (Side == 1) return vect(0,0,1) * Parent.CollisionRadius * -1 * Parent.DrawScale;
 if (Side == 2) return vect(1,0,0) * Parent.CollisionRadius * Parent.DrawScale;
 if (Side == 3) return vect(1,0,0) * Parent.CollisionRadius * -1 * Parent.DrawScale;
 if (Side == 4) return vect(0,1,0) * Parent.CollisionRadius * Parent.DrawScale;
 if (Side == 5) return vect(0,1,0) * Parent.CollisionRadius * -1 * Parent.DrawScale;
 
 return vect(0,0,0);
}

function Rotator GetRotator(int Side)
{
 //ZXY
 
 if (Side == 0) return rot(16384,0,0);
 if (Side == 1) return rot(-16384,0,0);
 if (Side == 2) return rot(0,0,0);
 if (Side == 3) return rot(0,32768,0);
 if (Side == 4) return rot(0,0,16384);
 if (Side == 5) return rot(0,0,-16384);
 
 return rot(0,0,0);
}

function Mesh GetMesh(int i)
{
 if (i == 0) return LODMesh'BlockFace0';
 if (i == 1) return LODMesh'BlockFace1';
 if (i == 2) return LODMesh'BlockFace2';
 if (i == 3) return LODMesh'BlockFace3';
 if (i == 4) return LODMesh'BlockFace4';
 if (i == 5) return LODMesh'BlockFace5';
 
 return none;
}

function SetSide(int i)
{
 CurSide = i;
}

function PostBeginPlay()
{
 Super.PostBeginPlay();
 
 SetTimer(0.1, True);
}

function Timer()
{
 local bool bRedundant;
 
 Super.Timer();
 
 //if (Parent == None || Parent.hitPoints <= 0) Destroy();
 
 bRedundant = (Parent.CurNeighbors[CurSide] != None && (Parent.CurNeighbors[CurSide].Style != STY_Translucent || Parent.Style == STY_Translucent) && Parent.CurNeighbors[CurSide].DrawMult == Parent.DrawMult);
 
 if (bRedundant) Mesh = None;
 
 if (!bRedundant)
 {
  if (Level.NetMode == NM_Standalone) Mesh = Default.Mesh;
  Skin = Parent.Multiskins[CurSide];
  DrawScale = Parent.DrawScale * ScaleMult; 
  Scaleglow = Parent.Scaleglow;
  Style = Parent.Style;
  
  SetLocation(Parent.Location + GetNormal(CurSide));
  if (Level.NetMode == NM_Standalone) SetRotation(Rotator(GetNormal(CurSide)));
  if (Level.NetMode != NM_Standalone) Mesh = GetMesh(CurSide);
  
 }
}

defaultproperties
{
 CollisionHeight=0.000000
 CollisionRadius=0.000000
 bBlockActors=False
 bBlockPlayers=False
 bProjTarget=False
 bCollideWorld=False
 bCollideActors=False
 Texture=None
 Drawtype=DT_Mesh
 Skin=None
 Mesh=LODMesh'MinecraftSheet'
 
 bNoSmooth=True
 bUnlit=True
 ScaleMult=182.000000
}
